/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console;

import filenet.sim.api.VWSIMSession;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.VWSIMConsoleMessage;
import filenet.sim.toolkit.console.VWSIMConsoleRootNode;
import filenet.sim.toolkit.console.VWSIMConsoleStatusEvent;
import filenet.sim.toolkit.console.images.VWSIMImageLoader;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.IVWSortItem;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class VWSIMBaseNode
extends DefaultMutableTreeNode
implements IVWSortItem {
    protected static final ImageIcon unknownIcon16 = VWSIMImageLoader.createImageIcon("unknode16.gif");
    public static final int NODE_TYPE_UNKNOWN = 0;
    public static final int NODE_TYPE_FOLDER = 16;
    public static final int NODE_TYPE_ROOT = 17;
    public static final int NODE_TYPE_TOP_FOLDER = 18;
    public static final int NODE_TYPE_PUBLISHED_DATA_FOLDER = 20;
    public static final int NODE_TYPE_SCENARIO = 33;
    public static final int NODE_TYPE_SIMULATION = 34;
    public static final int NODE_TYPE_PUBLISHED_SIMDATA = 36;
    public static final int NO_ORDER = 0;
    public static final int ASCENDING_ORDER = 1;
    public static final int DESCENDING_ORDER = 2;
    protected VWSession m_vwSession = null;
    protected VWSIMSession m_simSession = null;
    protected String m_name = null;
    protected ImageIcon m_icon16 = unknownIcon16;
    protected int m_type = 0;
    protected String m_actionCommand = VWSIMConsoleActionCommand.ACMD_UNKNOWN;
    protected IVWIDMItem m_idmItem = null;
    protected int m_eventStatus = 0;

    public VWSIMBaseNode(String name, int type) {
        super(name);
        this.m_name = name;
        this.m_type = type;
    }

    public VWSIMBaseNode(IVWIDMItem aIDMItem, int type, String actionCommand) {
        if (aIDMItem != null) {
            this.setName(aIDMItem.getLabel());
        }
        this.m_idmItem = aIDMItem;
        this.m_type = type;
        this.m_actionCommand = actionCommand;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public VWSIMSession getSimSession() {
        return this.m_simSession;
    }

    public void setSIMSession(VWSIMSession session) {
        this.m_simSession = session;
    }

    public VWSession getVWSession() {
        return this.m_vwSession;
    }

    public void setVWSession(VWSession session) {
        this.m_vwSession = session;
    }

    public String getActionCommandString() {
        return this.m_actionCommand;
    }

    public void setActionCommandString(String actionCommand) {
        this.m_actionCommand = actionCommand;
    }

    public Icon getIcon16() {
        return this.m_icon16;
    }

    public void setIcon16(ImageIcon icon) {
        this.m_icon16 = icon;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public void setIdmItem(IVWIDMItem idmItem) {
        this.m_idmItem = idmItem;
    }

    public IVWIDMItem getIdmItem() {
        return this.m_idmItem;
    }

    public String getLibraryName() {
        if (this.m_idmItem != null) {
            return this.m_idmItem.getLibraryLabel();
        }
        return null;
    }

    public String getLibraryId() {
        if (this.m_idmItem != null) {
            return this.m_idmItem.getLibraryId();
        }
        return null;
    }

    public String getDocID() {
        if (this.m_idmItem != null) {
            return this.m_idmItem.getId();
        }
        return null;
    }

    public String getDocName() {
        if (this.m_idmItem != null) {
            return this.m_idmItem.getLabel();
        }
        return null;
    }

    public void fireStatusEvent(VWSIMConsoleStatusEvent statusEvt) {
        try {
            VWSIMConsoleRootNode root = (VWSIMConsoleRootNode)this.findAncestorNode(17);
            root.fireConfigStatusEvent(statusEvt);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void fireStatusEvent(int statusType) {
        try {
            VWSIMConsoleRootNode root = (VWSIMConsoleRootNode)this.findAncestorNode(17);
            VWSIMConsoleStatusEvent statusEvt = new VWSIMConsoleStatusEvent(root, this, statusType);
            root.fireConfigStatusEvent(statusEvt);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void displayMessage(int msgType, String message) {
        VWSIMConsoleStatusEvent statusEvent = new VWSIMConsoleStatusEvent(this.getRoot(), this, 3);
        VWSIMConsoleMessage consoleMessage = new VWSIMConsoleMessage(msgType, message);
        statusEvent.setMessage(consoleMessage);
        this.fireStatusEvent(statusEvent);
    }

    public TreeNode getRoot() {
        VWSIMBaseNode previous;
        TreeNode ancestor = this;
        do {
            previous = ancestor;
        } while ((ancestor = ancestor.getParent()) != null);
        return previous;
    }

    public VWSIMBaseNode findAncestorNode(int type) {
        VWSIMBaseNode bNode = this;
        while (bNode.getType() != type && (bNode = (VWSIMBaseNode)bNode.getParent()) != null) {
        }
        return bNode;
    }

    public void add(VWSIMBaseNode newChild, int type) {
        block9: {
            try {
                int childCount = this.getChildCount();
                String newName = newChild.getName();
                if (childCount == 0) {
                    this.add(newChild);
                    break block9;
                }
                boolean bDone = false;
                String childName = null;
                if (type == 1) {
                    for (int i = 0; i < childCount; ++i) {
                        childName = ((VWSIMBaseNode)this.getChildAt(i)).getName();
                        if (VWStringUtils.compare(newName, childName) > 0) continue;
                        this.insert(newChild, i);
                        bDone = true;
                        break;
                    }
                } else if (type == 2) {
                    for (int i = 0; i < childCount; ++i) {
                        childName = ((VWSIMBaseNode)this.getChildAt(i)).getName();
                        if (VWStringUtils.compare(childName, newName) < 0) continue;
                        this.insert(newChild, i);
                        bDone = true;
                        break;
                    }
                }
                if (!bDone) {
                    this.add(newChild);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public void setChangeEventStatus(int status) {
        this.m_eventStatus = status;
    }

    public int getChangeEventStatus() {
        return this.m_eventStatus;
    }

    public void clearAll() {
        this.m_idmItem = null;
    }

    public boolean isFolderNode() {
        return (this.m_type & 0x10) > 0;
    }

    public void releaseResources() {
        this.m_vwSession = null;
        this.m_simSession = null;
        this.m_name = null;
        this.m_icon16 = null;
        this.m_actionCommand = null;
        this.m_idmItem = null;
        this.removeAllChildren();
        this.setUserObject(null);
    }
}

